/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.TranslatableComponent;

public enum Impact {
    NONE(0, "none", ChatFormatting.GRAY),
    LOW(1, "low", ChatFormatting.GREEN),
    MEDIUM(2, "medium", ChatFormatting.YELLOW),
    HIGH(3, "high", ChatFormatting.RED);

    private int impactValue;
    private String translationKey;
    private ChatFormatting textStyle;

    private Impact(int impactValue, String translationKey, ChatFormatting textStyle) {
        this.translationKey = "origins.gui.impact." + translationKey;
        this.impactValue = impactValue;
        this.textStyle = textStyle;
    }

    public int getImpactValue() {
        return this.impactValue;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public ChatFormatting getTextStyle() {
        return this.textStyle;
    }

    public TranslatableComponent getTextComponent() {
        return (TranslatableComponent)new TranslatableComponent(this.getTranslationKey()).m_130940_(this.getTextStyle());
    }

    public static Impact getByValue(int impactValue) {
        return Impact.values()[impactValue];
    }
}

