/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.apace100.origins.command.LayerArgumentType;
import io.github.apace100.origins.command.OriginArgumentType;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.S2COpenOriginScreen;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class OriginCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"origin").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"layer", (ArgumentType)LayerArgumentType.layer()).then(Commands.m_82129_((String)"origin", (ArgumentType)OriginArgumentType.origin()).executes(command -> {
            int i = 0;
            Collection targets = EntityArgument.m_91477_((CommandContext)command, (String)"targets");
            OriginLayer l = LayerArgumentType.getLayer((CommandContext<CommandSourceStack>)command, "layer");
            Origin o = OriginArgumentType.getOrigin((CommandContext<CommandSourceStack>)command, "origin");
            for (ServerPlayer target : targets) {
                OriginCommand.setOrigin((Player)target, l, o);
                ++i;
            }
            if (targets.size() == 1) {
                ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.origin.set.success.single", new Object[]{((ServerPlayer)targets.iterator().next()).m_5446_(), l.name(), o.getName()}), true);
            } else {
                ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.origin.set.success.multiple", new Object[]{targets.size(), l.name(), o.getName()}), true);
            }
            return i;
        })))))).then(Commands.m_82127_((String)"has").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"layer", (ArgumentType)LayerArgumentType.layer()).then(Commands.m_82129_((String)"origin", (ArgumentType)OriginArgumentType.origin()).executes(command -> {
            int i = 0;
            Collection targets = EntityArgument.m_91477_((CommandContext)command, (String)"targets");
            OriginLayer l = LayerArgumentType.getLayer((CommandContext<CommandSourceStack>)command, "layer");
            Origin o = OriginArgumentType.getOrigin((CommandContext<CommandSourceStack>)command, "origin");
            for (ServerPlayer target : targets) {
                if (!OriginCommand.hasOrigin((Player)target, l, o)) continue;
                ++i;
            }
            if (i == 0) {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.execute.conditional.fail"));
            } else if (targets.size() == 1) {
                ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.execute.conditional.pass"), false);
            } else {
                ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.execute.conditional.pass_count", new Object[]{i}), false);
            }
            return i;
        })))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"layer", (ArgumentType)LayerArgumentType.layer()).executes(command -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)command, (String)"target");
            OriginLayer layer = LayerArgumentType.getLayer((CommandContext<CommandSourceStack>)command, "layer");
            IOriginContainer.get((Entity)target).ifPresent(container -> {
                Origin origin = container.getOrigin(layer);
                ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.origin.get.result", new Object[]{target.m_5446_(), layer.name(), origin.getName(), origin.getRegistryName()}), false);
            });
            return 1;
        }))))).then(Commands.m_82127_((String)"gui").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(command -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)command, (String)"targets");
            targets.forEach(target -> IOriginContainer.get((Entity)target).ifPresent(container -> {
                OriginsAPI.getActiveLayers().forEach(x -> container.setOrigin((OriginLayer)x, Origin.EMPTY));
                container.synchronize();
                container.checkAutoChoosingLayers(false);
                OriginsCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> target), (Object)new S2COpenOriginScreen(false));
            }));
            ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.origin.gui.all", new Object[]{targets.size()}), false);
            return targets.size();
        })).then(Commands.m_82129_((String)"layer", (ArgumentType)LayerArgumentType.layer()).executes(command -> {
            OriginLayer layer = LayerArgumentType.getLayer((CommandContext<CommandSourceStack>)command, "layer");
            Collection targets = EntityArgument.m_91477_((CommandContext)command, (String)"targets");
            targets.forEach(target -> IOriginContainer.get((Entity)target).ifPresent(container -> {
                if (layer.enabled()) {
                    container.setOrigin(layer, Origin.EMPTY);
                }
                container.synchronize();
                container.checkAutoChoosingLayers(false);
                OriginsCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> target), (Object)new S2COpenOriginScreen(false));
            }));
            ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.origin.gui.layer", new Object[]{targets.size(), layer.name()}), false);
            return targets.size();
        })))));
    }

    private static void setOrigin(Player player, OriginLayer layer, Origin origin) {
        IOriginContainer.get((Entity)player).ifPresent(container -> {
            container.setOrigin(layer, origin);
            container.synchronize();
            container.onChosen(origin, container.hadAllOrigins());
        });
    }

    private static boolean hasOrigin(Player player, OriginLayer layer, Origin origin) {
        return IOriginContainer.get((Entity)player).map(x -> Objects.equals((Object)x.getOrigin(layer), (Object)origin)).orElse(false);
    }
}

