/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class OriginArgumentType
implements ArgumentType<ResourceLocation> {
    public static final DynamicCommandExceptionType ORIGIN_NOT_FOUND = new DynamicCommandExceptionType(p_208663_0_ -> new TranslatableComponent("commands.origin.origin_not_found", new Object[]{p_208663_0_}));

    public static OriginArgumentType origin() {
        return new OriginArgumentType();
    }

    public ResourceLocation parse(StringReader p_parse_1_) throws CommandSyntaxException {
        return ResourceLocation.m_135818_((StringReader)p_parse_1_);
    }

    public static Origin getOrigin(CommandContext<CommandSourceStack> context, String argumentName) throws CommandSyntaxException {
        ResourceLocation id = (ResourceLocation)context.getArgument(argumentName, ResourceLocation.class);
        Origin origin = (Origin)((Object)OriginsAPI.getOriginsRegistry().m_7745_(id));
        if (origin == null) {
            throw ORIGIN_NOT_FOUND.create((Object)id);
        }
        return origin;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        OriginLayer layer = null;
        try {
            layer = (OriginLayer)context.getArgument("layer", OriginLayer.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (layer != null) {
            LinkedList<ResourceLocation> ids = new LinkedList<ResourceLocation>(layer.origins());
            ids.add(Origin.EMPTY.getRegistryName());
            return SharedSuggestionProvider.m_82957_(ids.stream(), (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.m_82926_((Iterable)OriginsAPI.getOriginsRegistry().m_6566_(), (SuggestionsBuilder)builder);
    }
}

