/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.data;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.LazilyParsedNumber;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.Calio;
import io.github.apace100.calio.ClassUtil;
import io.github.apace100.calio.SerializationHelper;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.util.StatusEffectChance;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.tags.TagContainer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public final class SerializableDataTypes {
    public static final SerializableDataType<Integer> INT = new SerializableDataType<Integer>(Integer.class, (Codec<Integer>)Codec.INT);
    public static final SerializableDataType<List<Integer>> INTS = SerializableDataType.list(INT);
    public static final SerializableDataType<Boolean> BOOLEAN = new SerializableDataType<Boolean>(Boolean.class, (Codec<Boolean>)Codec.BOOL);
    public static final SerializableDataType<Float> FLOAT = new SerializableDataType<Float>(Float.class, (Codec<Float>)Codec.FLOAT);
    public static final SerializableDataType<List<Float>> FLOATS = SerializableDataType.list(FLOAT);
    public static final SerializableDataType<Double> DOUBLE = new SerializableDataType<Double>(Double.class, (Codec<Double>)Codec.DOUBLE);
    public static final SerializableDataType<String> STRING = new SerializableDataType<String>(String.class, (Codec<String>)Codec.STRING);
    public static final SerializableDataType<List<String>> STRINGS = SerializableDataType.list(STRING);
    public static final SerializableDataType<Number> NUMBER = new SerializableDataType<Number>(Number.class, (buf, number) -> {
        if (number instanceof Double) {
            buf.writeByte(0);
            buf.writeDouble(number.doubleValue());
        } else if (number instanceof Float) {
            buf.writeByte(1);
            buf.writeFloat(number.floatValue());
        } else if (number instanceof Integer) {
            buf.writeByte(2);
            buf.writeInt(number.intValue());
        } else if (number instanceof Long) {
            buf.writeByte(3);
            buf.writeLong(number.longValue());
        } else {
            buf.writeByte(4);
            buf.m_130070_(number.toString());
        }
    }, buf -> {
        byte type = buf.readByte();
        switch (type) {
            case 0: {
                return buf.readDouble();
            }
            case 1: {
                return Float.valueOf(buf.readFloat());
            }
            case 2: {
                return buf.readInt();
            }
            case 3: {
                return buf.readLong();
            }
            case 4: {
                return new LazilyParsedNumber(buf.m_130277_());
            }
        }
        throw new RuntimeException("Could not receive number, unexpected type id \"" + type + "\" (allowed range: [0-4])");
    }, je -> {
        if (je.isJsonPrimitive()) {
            JsonPrimitive primitive = je.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean() ? 1 : 0;
            }
        }
        throw new JsonParseException("Expected a primitive");
    }, JsonPrimitive::new);
    public static final SerializableDataType<List<Number>> NUMBERS = SerializableDataType.list(NUMBER);
    public static final SerializableDataType<Vec3> VECTOR = new SerializableDataType<Vec3>(Vec3.class, CalioCodecHelper.VEC3D.codec());
    public static final SerializableDataType<ResourceLocation> IDENTIFIER = new SerializableDataType<ResourceLocation>(ResourceLocation.class, FriendlyByteBuf::m_130085_, FriendlyByteBuf::m_130281_, json -> {
        Object idString = json.getAsString();
        if (((String)idString).contains(":")) {
            String[] idSplit = ((String)idString).split(":");
            if (idSplit.length != 2) {
                throw new ResourceLocationException("Incorrect number of `:` in identifier: \"" + (String)idString + "\".");
            }
            if (idSplit[0].contains("*")) {
                if (SerializableData.CURRENT_NAMESPACE != null) {
                    idSplit[0] = idSplit[0].replace("*", SerializableData.CURRENT_NAMESPACE);
                } else {
                    throw new ResourceLocationException("Identifier may not contain a `*` in the namespace when read here.");
                }
            }
            if (idSplit[1].contains("*")) {
                if (SerializableData.CURRENT_PATH != null) {
                    idSplit[1] = idSplit[1].replace("*", SerializableData.CURRENT_PATH);
                } else {
                    throw new ResourceLocationException("Identifier may only contain a `*` in the path inside of powers.");
                }
            }
            idString = idSplit[0] + ":" + idSplit[1];
        } else if (((String)idString).contains("*")) {
            if (SerializableData.CURRENT_PATH != null) {
                idString = ((String)idString).replace("*", SerializableData.CURRENT_PATH);
            } else {
                throw new ResourceLocationException("Identifier may only contain a `*` in the path inside of powers.");
            }
        }
        return new ResourceLocation((String)idString);
    }, x -> new JsonPrimitive(x.toString()));
    public static final SerializableDataType<List<ResourceLocation>> IDENTIFIERS = SerializableDataType.list(IDENTIFIER);
    public static final SerializableDataType<Enchantment> ENCHANTMENT = SerializableDataType.registry(Enchantment.class, Registry.f_122825_);
    public static final SerializableDataType<DamageSource> DAMAGE_SOURCE = SerializableDataType.compound(DamageSource.class, new SerializableData().add("name", STRING).add("bypasses_armor", BOOLEAN, false).add("fire", BOOLEAN, false).add("unblockable", BOOLEAN, false).add("magic", BOOLEAN, false).add("out_of_world", BOOLEAN, false).add("projectile", BOOLEAN, false).add("explosive", BOOLEAN, false), data -> {
        DamageSource damageSource = new DamageSource(data.getString("name"));
        if (data.getBoolean("bypasses_armor")) {
            damageSource.m_19380_();
        }
        if (data.getBoolean("fire")) {
            damageSource.m_19383_();
        }
        if (data.getBoolean("unblockable")) {
            damageSource.m_19382_();
        }
        if (data.getBoolean("magic")) {
            damageSource.m_19389_();
        }
        if (data.getBoolean("out_of_world")) {
            damageSource.m_19381_();
        }
        if (data.getBoolean("projectile")) {
            damageSource.m_19366_();
        }
        if (data.getBoolean("explosive")) {
            damageSource.m_19375_();
        }
        return damageSource;
    }, (data, ds) -> {
        SerializableData.Instance inst = (SerializableData)((Object)data).new SerializableData.Instance();
        inst.set("name", ds.m_19385_());
        inst.set("fire", ds.m_19384_());
        inst.set("unblockable", ds.m_19379_());
        inst.set("bypasses_armor", ds.m_19376_());
        inst.set("out_of_world", ds.m_19378_());
        inst.set("magic", ds.m_19387_());
        inst.set("projectile", ds.m_19360_());
        inst.set("explosive", ds.m_19372_());
        return inst;
    });
    public static final SerializableDataType<Attribute> ATTRIBUTE = SerializableDataType.registry(Attribute.class, Registry.f_122866_);
    public static final SerializableDataType<AttributeModifier.Operation> MODIFIER_OPERATION = SerializableDataType.enumValue(AttributeModifier.Operation.class);
    public static final SerializableDataType<AttributeModifier> ATTRIBUTE_MODIFIER = SerializableDataType.compound(AttributeModifier.class, new SerializableData().add("name", STRING, "Unnamed attribute modifier").add("operation", MODIFIER_OPERATION).add("value", DOUBLE), data -> new AttributeModifier(data.getString("name"), data.getDouble("value"), (AttributeModifier.Operation)data.get("operation")), (serializableData, modifier) -> {
        SerializableData.Instance inst = (SerializableData)((Object)serializableData).new SerializableData.Instance();
        inst.set("name", modifier.m_22214_());
        inst.set("value", modifier.m_22218_());
        inst.set("operation", modifier.m_22217_());
        return inst;
    });
    public static final SerializableDataType<List<AttributeModifier>> ATTRIBUTE_MODIFIERS = SerializableDataType.list(ATTRIBUTE_MODIFIER);
    public static final SerializableDataType<Item> ITEM = SerializableDataType.registry(Item.class, Registry.f_122827_);
    public static final SerializableDataType<MobEffect> STATUS_EFFECT = SerializableDataType.registry(MobEffect.class, Registry.f_122823_);
    public static final SerializableDataType<List<MobEffect>> STATUS_EFFECTS = SerializableDataType.list(STATUS_EFFECT);
    public static final SerializableDataType<MobEffectInstance> STATUS_EFFECT_INSTANCE = new SerializableDataType<MobEffectInstance>(MobEffectInstance.class, SerializationHelper::writeStatusEffect, SerializationHelper::readStatusEffect, SerializationHelper::readStatusEffect, SerializationHelper::writeStatusEffect);
    public static final SerializableDataType<List<MobEffectInstance>> STATUS_EFFECT_INSTANCES = SerializableDataType.list(STATUS_EFFECT_INSTANCE);
    public static final SerializableDataType<Tag<Item>> ITEM_TAG = SerializableDataType.tag(Registry.f_122904_);
    public static final SerializableDataType<Tag<Fluid>> FLUID_TAG = SerializableDataType.tag(Registry.f_122899_);
    public static final SerializableDataType<Tag<Block>> BLOCK_TAG = SerializableDataType.tag(Registry.f_122901_);
    public static final SerializableDataType<Tag<EntityType<?>>> ENTITY_TAG = SerializableDataType.tag(Registry.f_122903_);
    public static final SerializableDataType<List<Item>> INGREDIENT_ENTRY = new SerializableDataType(ClassUtil.castClass(List.class), RecordCodecBuilder.create(instance -> instance.group((App)CalioCodecHelper.optionalField(ITEM, "item").forGetter(x -> x.size() == 1 ? Optional.of((Item)x.get(0)) : Optional.empty()), (App)CalioCodecHelper.optionalField(ITEM_TAG, "tag").forGetter(items -> {
        if (items.size() == 1) {
            return Optional.empty();
        }
        TagContainer tagManager = Calio.getTagManager();
        TagCollection tagGroup = tagManager.m_144452_(Registry.f_122904_);
        Collection possibleTags = tagGroup.m_13394_((Object)((Item)items.get(0)));
        for (int i = 1; i < items.size() && possibleTags.size() > 1; ++i) {
            possibleTags.removeAll(tagGroup.m_13394_((Object)((Item)items.get(i))));
        }
        if (possibleTags.size() != 1) {
            throw new IllegalStateException("Couldn't transform item list to a single tag");
        }
        return possibleTags.stream().findFirst().map(arg_0 -> ((TagCollection)tagGroup).m_13404_(arg_0));
    })).apply((Applicative)instance, (item, itemTag) -> itemTag.map(Tag::m_6497_).or(() -> item.map(ImmutableList::of)).orElseGet(ImmutableList::of))));
    public static final SerializableDataType<List<List<Item>>> INGREDIENT_ENTRIES = SerializableDataType.list(INGREDIENT_ENTRY);
    public static final SerializableDataType<Ingredient> INGREDIENT = new SerializableDataType<Ingredient>(Ingredient.class, (buffer, ingredient) -> ingredient.m_43923_(buffer), Ingredient::m_43940_, jsonElement -> {
        List<List<Item>> itemLists = INGREDIENT_ENTRIES.read((JsonElement)jsonElement);
        LinkedList items = new LinkedList();
        itemLists.forEach(itemList -> itemList.forEach(item -> items.add(new ItemStack((ItemLike)item))));
        return Ingredient.m_43921_(items.stream());
    }, Ingredient::m_43942_);
    public static final SerializableDataType<Ingredient> VANILLA_INGREDIENT = new SerializableDataType<Ingredient>(Ingredient.class, (buffer, ingredient) -> ingredient.m_43923_(buffer), Ingredient::m_43940_, Ingredient::m_43917_, Ingredient::m_43942_);
    public static final SerializableDataType<Block> BLOCK = SerializableDataType.registry(Block.class, Registry.f_122824_);
    public static final SerializableDataType<BlockState> BLOCK_STATE = SerializableDataType.wrap(BlockState.class, STRING, BlockStateParser::m_116769_, string -> {
        try {
            return new BlockStateParser(new StringReader(string), false).m_116806_(false).m_116808_();
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException((Throwable)e);
        }
    });
    public static final SerializableDataType<MobType> ENTITY_GROUP = SerializableDataType.mapped(MobType.class, HashBiMap.create((Map)ImmutableMap.of((Object)"default", (Object)MobType.f_21640_, (Object)"undead", (Object)MobType.f_21641_, (Object)"arthropod", (Object)MobType.f_21642_, (Object)"illager", (Object)MobType.f_21643_, (Object)"aquatic", (Object)MobType.f_21644_)));
    public static final SerializableDataType<EquipmentSlot> EQUIPMENT_SLOT = SerializableDataType.enumValue(EquipmentSlot.class);
    public static final SerializableDataType<SoundEvent> SOUND_EVENT = SerializableDataType.registry(SoundEvent.class, Registry.f_122821_);
    public static final SerializableDataType<EntityType<?>> ENTITY_TYPE = SerializableDataType.registry(ClassUtil.castClass(EntityType.class), Registry.f_122826_);
    public static final SerializableDataType<ParticleType<?>> PARTICLE_TYPE = SerializableDataType.registry(ClassUtil.castClass(ParticleType.class), Registry.f_122829_);
    public static final SerializableDataType<ParticleOptions> PARTICLE_EFFECT = SerializableDataType.compound(ParticleOptions.class, new SerializableData().add("type", PARTICLE_TYPE).add("params", STRING, ""), dataInstance -> {
        ParticleType particleType = (ParticleType)dataInstance.get("type");
        ParticleOptions.Deserializer factory = particleType.m_123743_();
        ParticleOptions effect = null;
        try {
            effect = factory.m_5739_(particleType, new StringReader(" " + dataInstance.getString("params")));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        return effect;
    }, (serializableData, particleEffect) -> {
        SerializableData.Instance data = (SerializableData)((Object)serializableData).new SerializableData.Instance();
        data.set("type", particleEffect.m_6012_());
        String params = particleEffect.m_5942_();
        int spaceIndex = params.indexOf(32);
        params = spaceIndex > -1 ? params.substring(spaceIndex + 1) : "";
        data.set("params", params);
        return data;
    });
    public static final SerializableDataType<ParticleOptions> PARTICLE_EFFECT_OR_TYPE = new SerializableDataType<ParticleOptions>(ParticleOptions.class, PARTICLE_EFFECT::send, PARTICLE_EFFECT::receive, jsonElement -> {
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            ParticleType<?> type = PARTICLE_TYPE.read((JsonElement)jsonElement);
            if (type instanceof ParticleOptions) {
                return (ParticleOptions)type;
            }
            throw new RuntimeException("Expected either a string with a parameter-less particle effect, or an object.");
        }
        if (jsonElement.isJsonObject()) {
            return PARTICLE_EFFECT.read((JsonElement)jsonElement);
        }
        throw new RuntimeException("Expected either a string with a parameter-less particle effect, or an object.");
    }, PARTICLE_EFFECT::write);
    public static final SerializableDataType<CompoundTag> NBT = SerializableDataType.wrap(CompoundTag.class, STRING, CompoundTag::toString, str -> {
        try {
            return new TagParser(new StringReader(str)).m_129373_();
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Could not parse NBT tag, exception: " + e.getMessage());
        }
    });
    public static final SerializableDataType<ItemStack> ITEM_STACK = new SerializableDataType<ItemStack>(ItemStack.class, RecordCodecBuilder.create(instance -> instance.group((App)ITEM.fieldOf("item").forGetter(ItemStack::m_41720_), (App)CalioCodecHelper.optionalField(Codec.INT, "amount", 1).forGetter(ItemStack::m_41613_), (App)CalioCodecHelper.optionalField(NBT, "tag").forGetter(x -> Optional.ofNullable(x.m_41783_()))).apply((Applicative)instance, (t1, t2, t3) -> {
        ItemStack itemStack = new ItemStack((ItemLike)t1, t2.intValue());
        t3.ifPresent(arg_0 -> ((ItemStack)itemStack).m_41751_(arg_0));
        return itemStack;
    })));
    public static final SerializableDataType<List<ItemStack>> ITEM_STACKS = SerializableDataType.list(ITEM_STACK);
    public static final SerializableDataType<Component> TEXT = new SerializableDataType<Component>(Component.class, (buffer, text) -> buffer.m_130070_(Component.Serializer.m_130703_((Component)text)), buffer -> Component.Serializer.m_130701_((String)buffer.m_130277_()), Component.Serializer::m_130691_, Component.Serializer::m_130716_);
    public static final SerializableDataType<List<Component>> TEXTS = SerializableDataType.list(TEXT);
    public static SerializableDataType<ResourceKey<Level>> DIMENSION = SerializableDataType.wrap(ClassUtil.castClass(ResourceKey.class), IDENTIFIER, ResourceKey::m_135782_, identifier -> ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)identifier));
    public static final SerializableDataType<Recipe> RECIPE = new SerializableDataType<Recipe>(Recipe.class, (buffer, recipe) -> {
        buffer.m_130085_(recipe.m_7707_().getRegistryName());
        buffer.m_130085_(recipe.m_6423_());
        recipe.m_7707_().m_6178_(buffer, recipe);
    }, buffer -> {
        ResourceLocation recipeSerializerId = buffer.m_130281_();
        ResourceLocation recipeId = buffer.m_130281_();
        RecipeSerializer serializer = (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(recipeSerializerId);
        return serializer.m_8005_(recipeId, buffer);
    }, jsonElement -> {
        if (!jsonElement.isJsonObject()) {
            throw new RuntimeException("Expected recipe to be a JSON object.");
        }
        JsonObject json = jsonElement.getAsJsonObject();
        ResourceLocation recipeSerializerId = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"type"));
        ResourceLocation recipeId = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"id"));
        RecipeSerializer serializer = (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(recipeSerializerId);
        return serializer.m_6729_(recipeId, json);
    });
    public static final SerializableDataType<GameEvent> GAME_EVENT = SerializableDataType.registry(GameEvent.class, Registry.f_175412_);
    public static final SerializableDataType<List<GameEvent>> GAME_EVENTS = SerializableDataType.list(GAME_EVENT);
    public static final SerializableDataType<Tag<GameEvent>> GAME_EVENT_TAG = SerializableDataType.tag(Registry.f_175423_);
    public static final SerializableDataType<Fluid> FLUID = SerializableDataType.registry(Fluid.class, Registry.f_122822_);
    public static final SerializableDataType<FogType> CAMERA_SUBMERSION_TYPE = SerializableDataType.enumValue(FogType.class);
    public static final SerializableDataType<InteractionHand> HAND = SerializableDataType.enumValue(InteractionHand.class);
    public static final SerializableDataType<EnumSet<InteractionHand>> HAND_SET = SerializableDataType.enumSet(InteractionHand.class, HAND);
    public static final SerializableDataType<EnumSet<EquipmentSlot>> EQUIPMENT_SLOT_SET = SerializableDataType.enumSet(EquipmentSlot.class, EQUIPMENT_SLOT);
    public static final SerializableDataType<InteractionResult> ACTION_RESULT = SerializableDataType.enumValue(InteractionResult.class);
    public static final SerializableDataType<UseAnim> USE_ACTION = SerializableDataType.enumValue(UseAnim.class);
    public static final SerializableDataType<StatusEffectChance> STATUS_EFFECT_CHANCE = SerializableDataType.compound(StatusEffectChance.class, new SerializableData().add("effect", STATUS_EFFECT_INSTANCE).add("chance", FLOAT, Float.valueOf(1.0f)), data -> {
        StatusEffectChance sec = new StatusEffectChance();
        sec.statusEffectInstance = (MobEffectInstance)data.get("effect");
        sec.chance = data.getFloat("chance");
        return sec;
    }, (data, csei) -> {
        SerializableData.Instance inst = (SerializableData)((Object)data).new SerializableData.Instance();
        inst.set("effect", csei.statusEffectInstance);
        inst.set("chance", Float.valueOf(csei.chance));
        return inst;
    });
    public static final SerializableDataType<List<StatusEffectChance>> STATUS_EFFECT_CHANCES = SerializableDataType.list(STATUS_EFFECT_CHANCE);
    public static final SerializableDataType<FoodProperties> FOOD_COMPONENT = SerializableDataType.compound(FoodProperties.class, new SerializableData().add("hunger", INT).add("saturation", FLOAT).add("meat", BOOLEAN, false).add("always_edible", BOOLEAN, false).add("snack", BOOLEAN, false).add("effect", STATUS_EFFECT_CHANCE, null).add("effects", STATUS_EFFECT_CHANCES, null), data -> {
        FoodProperties.Builder builder = new FoodProperties.Builder().m_38760_(data.getInt("hunger")).m_38758_(data.getFloat("saturation"));
        if (data.getBoolean("meat")) {
            builder.m_38757_();
        }
        if (data.getBoolean("always_edible")) {
            builder.m_38765_();
        }
        if (data.getBoolean("snack")) {
            builder.m_38766_();
        }
        data.ifPresent("effect", sec -> builder.m_38762_(sec.statusEffectInstance, sec.chance));
        data.ifPresent("effects", secs -> secs.forEach(sec -> builder.m_38762_(sec.statusEffectInstance, sec.chance)));
        return builder.m_38767_();
    }, (data, fc) -> {
        SerializableData.Instance inst = (SerializableData)((Object)data).new SerializableData.Instance();
        inst.set("hunger", fc.m_38744_());
        inst.set("saturation", Float.valueOf(fc.m_38745_()));
        inst.set("meat", fc.m_38746_());
        inst.set("always_edible", fc.m_38747_());
        inst.set("snack", fc.m_38748_());
        inst.set("effect", null);
        LinkedList statusEffectChances = new LinkedList();
        fc.m_38749_().forEach(pair -> {
            StatusEffectChance sec = new StatusEffectChance();
            sec.statusEffectInstance = (MobEffectInstance)pair.getFirst();
            sec.chance = ((Float)pair.getSecond()).floatValue();
            statusEffectChances.add(sec);
        });
        if (statusEffectChances.size() > 0) {
            inst.set("effects", statusEffectChances);
        } else {
            inst.set("effects", null);
        }
        return inst;
    });
    public static final SerializableDataType<Direction> DIRECTION = SerializableDataType.enumValue(Direction.class);
    public static final SerializableDataType<EnumSet<Direction>> DIRECTION_SET = SerializableDataType.enumSet(Direction.class, DIRECTION);
    public static final SerializableDataType<Class<?>> CLASS = SerializableDataType.wrap(ClassUtil.castClass(Class.class), STRING, Class::getName, str -> {
        try {
            return Class.forName(str);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Specified class does not exist: \"" + str + "\".");
        }
    });
    public static final SerializableDataType<ClipContext.Block> SHAPE_TYPE = SerializableDataType.enumValue(ClipContext.Block.class);
    public static final SerializableDataType<ClipContext.Fluid> FLUID_HANDLING = SerializableDataType.enumValue(ClipContext.Fluid.class);
    public static final SerializableDataType<Explosion.BlockInteraction> DESTRUCTION_TYPE = SerializableDataType.enumValue(Explosion.BlockInteraction.class);
    public static final SerializableDataType<Direction.Axis> AXIS = SerializableDataType.enumValue(Direction.Axis.class);
    public static final SerializableDataType<EnumSet<Direction.Axis>> AXIS_SET = SerializableDataType.enumSet(Direction.Axis.class, AXIS);
    private static final HashMap<String, Material> MATERIAL_MAP = new HashMap();
    public static final SerializableDataType<Material> MATERIAL;
    public static final SerializableDataType<List<Material>> MATERIALS;

    static {
        MATERIAL_MAP.put("air", Material.f_76296_);
        MATERIAL_MAP.put("structure_void", Material.f_76297_);
        MATERIAL_MAP.put("portal", Material.f_76298_);
        MATERIAL_MAP.put("carpet", Material.f_76299_);
        MATERIAL_MAP.put("plant", Material.f_76300_);
        MATERIAL_MAP.put("underwater_plant", Material.f_76301_);
        MATERIAL_MAP.put("replaceable_plant", Material.f_76302_);
        MATERIAL_MAP.put("nether_shoots", Material.f_76303_);
        MATERIAL_MAP.put("replaceable_underwater_plant", Material.f_76304_);
        MATERIAL_MAP.put("water", Material.f_76305_);
        MATERIAL_MAP.put("bubble_column", Material.f_76306_);
        MATERIAL_MAP.put("lava", Material.f_76307_);
        MATERIAL_MAP.put("snow_layer", Material.f_76308_);
        MATERIAL_MAP.put("fire", Material.f_76309_);
        MATERIAL_MAP.put("decoration", Material.f_76310_);
        MATERIAL_MAP.put("cobweb", Material.f_76311_);
        MATERIAL_MAP.put("sculk", Material.f_164533_);
        MATERIAL_MAP.put("redstone_lamp", Material.f_76312_);
        MATERIAL_MAP.put("organic_product", Material.f_76313_);
        MATERIAL_MAP.put("soil", Material.f_76314_);
        MATERIAL_MAP.put("solid_organic", Material.f_76315_);
        MATERIAL_MAP.put("dense_ice", Material.f_76316_);
        MATERIAL_MAP.put("aggregate", Material.f_76317_);
        MATERIAL_MAP.put("sponge", Material.f_76318_);
        MATERIAL_MAP.put("shulker_box", Material.f_76319_);
        MATERIAL_MAP.put("wood", Material.f_76320_);
        MATERIAL_MAP.put("nether_wood", Material.f_76321_);
        MATERIAL_MAP.put("bamboo_sapling", Material.f_76270_);
        MATERIAL_MAP.put("bamboo", Material.f_76271_);
        MATERIAL_MAP.put("wool", Material.f_76272_);
        MATERIAL_MAP.put("tnt", Material.f_76273_);
        MATERIAL_MAP.put("leaves", Material.f_76274_);
        MATERIAL_MAP.put("glass", Material.f_76275_);
        MATERIAL_MAP.put("ice", Material.f_76276_);
        MATERIAL_MAP.put("cactus", Material.f_76277_);
        MATERIAL_MAP.put("stone", Material.f_76278_);
        MATERIAL_MAP.put("metal", Material.f_76279_);
        MATERIAL_MAP.put("snow_block", Material.f_76280_);
        MATERIAL_MAP.put("repair_station", Material.f_76281_);
        MATERIAL_MAP.put("barrier", Material.f_76282_);
        MATERIAL_MAP.put("piston", Material.f_76283_);
        MATERIAL_MAP.put("moss_block", Material.f_164530_);
        MATERIAL_MAP.put("gourd", Material.f_76285_);
        MATERIAL_MAP.put("egg", Material.f_76286_);
        MATERIAL_MAP.put("cake", Material.f_76287_);
        MATERIAL_MAP.put("amethyst", Material.f_164531_);
        MATERIAL_MAP.put("powder_snow", Material.f_164532_);
        MATERIAL = SerializableDataType.mapped(Material.class, HashBiMap.create(MATERIAL_MAP));
        MATERIALS = SerializableDataType.list(MATERIAL);
    }
}

