/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import io.github.apace100.calio.data.DataException;
import io.github.apace100.calio.data.SerializableDataType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class SerializableData
extends MapCodec<Instance> {
    public static String CURRENT_NAMESPACE;
    public static String CURRENT_PATH;
    private final LinkedHashMap<String, Entry<?>> dataFields = new LinkedHashMap();

    public SerializableData add(String name, SerializableDataType<?> type) {
        this.dataFields.put(name, new Entry(type));
        return this;
    }

    public <T> SerializableData add(String name, SerializableDataType<T> type, T defaultValue) {
        this.dataFields.put(name, new Entry<T>(type, defaultValue));
        return this;
    }

    public <T> SerializableData addFunctionedDefault(String name, SerializableDataType<T> type, Function<Instance, T> defaultFunction) {
        this.dataFields.put(name, new Entry<T>(type, defaultFunction));
        return this;
    }

    public void write(FriendlyByteBuf buffer, Instance instance) {
        this.dataFields.forEach((name, entry) -> {
            try {
                boolean isPresent;
                boolean bl = isPresent = instance.get((String)name) != null;
                if (entry.hasDefault && entry.defaultValue == null) {
                    buffer.writeBoolean(isPresent);
                }
                if (isPresent) {
                    entry.dataType.send(buffer, instance.get((String)name));
                }
            }
            catch (DataException e) {
                throw e.prepend((String)name);
            }
            catch (Exception e) {
                throw new DataException(DataException.Phase.WRITING, (String)name, e);
            }
        });
    }

    public Instance read(FriendlyByteBuf buffer) {
        Instance instance = new Instance();
        this.dataFields.forEach((name, entry) -> {
            try {
                boolean isPresent = true;
                if (entry.hasDefault && entry.defaultValue == null) {
                    isPresent = buffer.readBoolean();
                }
                instance.set((String)name, isPresent ? entry.dataType.receive(buffer) : null);
            }
            catch (DataException e) {
                throw e.prepend((String)name);
            }
            catch (Exception e) {
                throw new DataException(DataException.Phase.RECEIVING, (String)name, e);
            }
        });
        return instance;
    }

    public Instance read(JsonObject jsonObject) {
        Instance instance = new Instance();
        this.dataFields.forEach((name, entry) -> {
            try {
                if (!jsonObject.has(name)) {
                    if (!entry.hasDefault()) throw new JsonSyntaxException("JSON requires field: " + name);
                    instance.set((String)name, entry.getDefault(instance));
                    return;
                } else {
                    instance.set((String)name, entry.dataType.read(jsonObject.get(name)));
                }
                return;
            }
            catch (DataException e) {
                throw e.prepend((String)name);
            }
            catch (Exception e) {
                throw new DataException(DataException.Phase.READING, (String)name, e);
            }
        });
        return instance;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.empty();
    }

    public <T> DataResult<Instance> decode(DynamicOps<T> ops, MapLike<T> input) {
        DataResult map = DataResult.success(input);
        return map.flatMap(fields -> {
            DataResult result = DataResult.success((Object)new Instance());
            for (Map.Entry<String, Entry<?>> entry : this.dataFields.entrySet()) {
                result = result.flatMap(x -> {
                    Object t = fields.get((String)entry.getKey());
                    if (t == null) {
                        if (!((Entry)entry.getValue()).hasDefault()) {
                            return DataResult.error((String)("Missing required field: " + (String)entry.getKey()));
                        }
                        x.set((String)entry.getKey(), ((Entry)entry.getValue()).getDefault((Instance)x));
                        return DataResult.success((Object)x);
                    }
                    return ((Entry)entry.getValue()).dataType.decode(ops, t).map(Pair::getFirst).map(obj -> {
                        x.set((String)entry.getKey(), obj);
                        return x;
                    });
                });
            }
            return result;
        });
    }

    public <T> RecordBuilder<T> encode(Instance input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        input.data.forEach((key, value) -> {
            Entry<?> entry = this.dataFields.get(key);
            prefix.add(key, entry.dataType.encodeStart(ops, value));
        });
        return prefix;
    }

    private static class Entry<T> {
        public final SerializableDataType<T> dataType;
        public final T defaultValue;
        private final Function<Instance, T> defaultFunction;
        private final boolean hasDefault;
        private final boolean hasDefaultFunction;

        public Entry(SerializableDataType<T> dataType) {
            this.dataType = dataType;
            this.defaultValue = null;
            this.defaultFunction = null;
            this.hasDefault = false;
            this.hasDefaultFunction = false;
        }

        public Entry(SerializableDataType<T> dataType, T defaultValue) {
            this.dataType = dataType;
            this.defaultValue = defaultValue;
            this.defaultFunction = null;
            this.hasDefault = true;
            this.hasDefaultFunction = false;
        }

        public Entry(SerializableDataType<T> dataType, Function<Instance, T> defaultFunction) {
            this.dataType = dataType;
            this.defaultValue = null;
            this.defaultFunction = defaultFunction;
            this.hasDefault = false;
            this.hasDefaultFunction = true;
        }

        public boolean hasDefault() {
            return this.hasDefault || this.hasDefaultFunction;
        }

        public T getDefault(Instance dataInstance) {
            if (this.hasDefaultFunction) {
                return this.defaultFunction.apply(dataInstance);
            }
            if (this.hasDefault) {
                return this.defaultValue;
            }
            throw new IllegalStateException("Tried to access default value of serializable data entry, when no default was provided.");
        }
    }

    public class Instance {
        private final HashMap<String, Object> data = new HashMap();

        public boolean isPresent(String name) {
            if (SerializableData.this.dataFields.containsKey(name)) {
                Entry<?> entry = SerializableData.this.dataFields.get(name);
                if (entry.hasDefault && entry.defaultValue == null) {
                    return this.get(name) != null;
                }
            }
            return true;
        }

        public <T> void ifPresent(String name, Consumer<T> consumer) {
            if (this.isPresent(name)) {
                consumer.accept(this.get(name));
            }
        }

        public void set(String name, Object value) {
            this.data.put(name, value);
        }

        public <T> T get(String name) {
            if (!this.data.containsKey(name)) {
                throw new RuntimeException("Tried to get field \"" + name + "\" from data, which did not exist.");
            }
            return (T)this.data.get(name);
        }

        public int getInt(String name) {
            return (Integer)this.get(name);
        }

        public boolean getBoolean(String name) {
            return (Boolean)this.get(name);
        }

        public float getFloat(String name) {
            return ((Float)this.get(name)).floatValue();
        }

        public double getDouble(String name) {
            return (Double)this.get(name);
        }

        public String getString(String name) {
            return (String)this.get(name);
        }

        public ResourceLocation getId(String name) {
            return (ResourceLocation)this.get(name);
        }

        public AttributeModifier getModifier(String name) {
            return (AttributeModifier)this.get(name);
        }
    }
}

