/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio;

import io.github.apace100.calio.CodeTriggerCriterion;
import io.github.apace100.calio.util.ClientTagManagerGetter;
import io.github.apace100.calio.util.ServerTagManagerGetter;
import io.github.apace100.calio.util.TagManagerGetter;
import io.github.edwinmindcraft.calio.api.CalioAPI;
import io.github.edwinmindcraft.calio.common.CalioCommon;
import io.github.edwinmindcraft.calio.common.CalioConfig;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;

@Mod(value="calio")
public class Calio {
    public static final ResourceLocation PACKET_SHARE_ITEM = new ResourceLocation("calio", "share_item");
    static TagManagerGetter tagManagerGetter;

    public static boolean isDebugMode() {
        return (Boolean)CalioConfig.COMMON.debugMode.get();
    }

    public Calio() {
        CalioAPI.LOGGER.info("Calio {} initializing...", (Object)ModLoadingContext.get().getActiveContainer().getModInfo().getVersion());
        CalioCommon.initialize();
        CriteriaTriggers.m_10595_((CriterionTrigger)CodeTriggerCriterion.INSTANCE);
        tagManagerGetter = (TagManagerGetter)DistExecutor.safeRunForDist(() -> ClientTagManagerGetter::new, () -> ServerTagManagerGetter::new);
    }

    public static boolean hasNonItalicName(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag display = stack.m_41737_("display");
            return display != null && display.m_128471_("NonItalicName");
        }
        return false;
    }

    public static void setNameNonItalic(ItemStack stack) {
        if (stack != null) {
            stack.m_41698_("display").m_128379_("NonItalicName", true);
        }
    }

    public static boolean areEntityAttributesAdditional(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("AdditionalAttributes") && stack.m_41783_().m_128471_("AdditionalAttributes");
    }

    public static void setEntityAttributesAdditional(ItemStack stack, boolean additional) {
        if (stack != null) {
            if (additional) {
                stack.m_41784_().m_128379_("AdditionalAttributes", true);
            } else if (stack.m_41782_()) {
                stack.m_41783_().m_128473_("AdditionalAttributes");
            }
        }
    }

    public static TagContainer getTagManager() {
        return tagManagerGetter.get();
    }

    public static <T> boolean areTagsEqual(ResourceKey<? extends Registry<T>> registryKey, Tag<T> tag1, Tag<T> tag2) {
        if (tag1 == tag2) {
            return true;
        }
        if (tag1 == null || tag2 == null) {
            return false;
        }
        TagContainer tagManager = Calio.getTagManager();
        try {
            ResourceLocation id1 = tag1 instanceof Tag.Named ? ((Tag.Named)tag1).m_6979_() : tagManager.m_144454_(registryKey, tag1, RuntimeException::new);
            ResourceLocation id2 = tag2 instanceof Tag.Named ? ((Tag.Named)tag2).m_6979_() : tagManager.m_144454_(registryKey, tag2, RuntimeException::new);
            return id1.equals((Object)id2);
        }
        catch (Exception e) {
            return false;
        }
    }
}

