/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.util.PowerGrantingItem;
import io.github.edwinmindcraft.apoli.common.registry.ApoliCapabilities;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public final class StackPowerUtil {
    public static void addPower(ItemStack stack, EquipmentSlot slot, ResourceLocation powerId) {
        StackPowerUtil.addPower(stack, slot, powerId, false, false);
    }

    public static void addPower(ItemStack stack, EquipmentSlot slot, ResourceLocation powerId, boolean isHidden, boolean isNegative) {
        StackPower stackPower = new StackPower();
        stackPower.slot = slot;
        stackPower.powerId = powerId;
        stackPower.isHidden = isHidden;
        stackPower.isNegative = isNegative;
        StackPowerUtil.addPower(stack, stackPower);
    }

    public static void addPower(ItemStack stack, StackPower stackPower) {
        ListTag list;
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("Powers")) {
            Tag elem = nbt.m_128423_("Powers");
            if (elem.m_7060_() != 9) {
                Apoli.LOGGER.warn("Can''t add power {} to item stack {}, as it contains conflicting NBT data.", (Object)stackPower.powerId, (Object)stack);
                return;
            }
            list = (ListTag)elem;
        } else {
            list = new ListTag();
            nbt.m_128365_("Powers", (Tag)list);
        }
        list.add((Object)stackPower.toNbt());
    }

    public static List<StackPower> getPowers(ItemStack stack, EquipmentSlot slot) {
        Item item;
        CompoundTag nbt = stack.m_41783_();
        LinkedList<StackPower> powers = new LinkedList<StackPower>();
        LazyOptional capability = stack.getCapability(ApoliCapabilities.POWER_GRANTING_ITEM);
        capability.ifPresent(pgi -> powers.addAll(pgi.getPowers(stack, slot)));
        if (!capability.isPresent() && (item = stack.m_41720_()) instanceof PowerGrantingItem) {
            PowerGrantingItem pgi2 = (PowerGrantingItem)item;
            powers.addAll(pgi2.getPowers(stack, slot));
            Apoli.LOGGER.warn("Found item granting powers without proper capability support: " + stack);
        }
        if (nbt != null && nbt.m_128441_("Powers")) {
            ListTag list = nbt.m_128437_("Powers", 10);
            for (int i = 0; i < list.size(); ++i) {
                StackPower power = StackPower.fromNbt(list.m_128728_(i));
                if (power.slot != slot) continue;
                powers.add(power);
            }
        }
        return powers;
    }

    public static class StackPower {
        public EquipmentSlot slot;
        public ResourceLocation powerId;
        public boolean isHidden;
        public boolean isNegative;

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("Slot", this.slot.m_20751_());
            nbt.m_128359_("Power", this.powerId.toString());
            nbt.m_128379_("Hidden", this.isHidden);
            nbt.m_128379_("Negative", this.isNegative);
            return nbt;
        }

        public static StackPower fromNbt(CompoundTag nbt) {
            StackPower stackPower = new StackPower();
            stackPower.slot = EquipmentSlot.m_20747_((String)nbt.m_128461_("Slot"));
            stackPower.powerId = new ResourceLocation(nbt.m_128461_("Power"));
            stackPower.isHidden = nbt.m_128441_("Hidden") && nbt.m_128471_("Hidden");
            stackPower.isNegative = nbt.m_128441_("Negative") && nbt.m_128471_("Negative");
            return stackPower;
        }
    }
}

