/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record HudRender(boolean shouldRender, int barIndex, ResourceLocation spriteLocation, ConfiguredEntityCondition<?, ?> condition, boolean inverted) {
    private static final ResourceLocation DEFAULT_SPRITE = new ResourceLocation("origins", "textures/gui/resource_bar.png");
    public static final Codec<HudRender> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CalioCodecHelper.optionalField(Codec.BOOL, "should_render", true).forGetter(HudRender::shouldRender), (App)CalioCodecHelper.optionalField(Codec.INT, "bar_index", 0).forGetter(HudRender::barIndex), (App)CalioCodecHelper.optionalField(ResourceLocation.f_135803_, "sprite_location", DEFAULT_SPRITE).forGetter(HudRender::spriteLocation), (App)CalioCodecHelper.optionalField(ConfiguredEntityCondition.CODEC, "condition").forGetter(x -> Optional.ofNullable(x.condition())), (App)CalioCodecHelper.optionalField(Codec.BOOL, "inverted", false).forGetter(HudRender::inverted)).apply((Applicative)instance, (t1, t2, t3, t4, t5) -> new HudRender((boolean)t1, (int)t2, (ResourceLocation)t3, t4.orElse(null), (boolean)t5)));
    public static final HudRender DONT_RENDER = new HudRender(false, 0, DEFAULT_SPRITE, null, false);

    public ResourceLocation getSpriteLocation() {
        return this.spriteLocation();
    }

    public int getBarIndex() {
        return this.barIndex();
    }

    public boolean isInverted() {
        return this.inverted();
    }

    public boolean shouldRender(Player player) {
        return this.shouldRender() && (this.condition() == null || this.condition().check((Entity)player));
    }

    public ConfiguredEntityCondition<?, ?> getCondition() {
        return this.condition();
    }
}

