/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action.entity;

import io.github.apace100.apoli.action.configuration.RaycastConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiEntityAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityAction;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityAction;
import io.github.edwinmindcraft.apoli.common.action.configuration.CommandConfiguration;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RaycastAction
extends EntityAction<RaycastConfiguration> {
    public RaycastAction() {
        super(RaycastConfiguration.CODEC);
    }

    @Override
    public void execute(@NotNull RaycastConfiguration configuration, @NotNull Entity entity) {
        ConfiguredEntityAction.execute(configuration.beforeAction(), entity);
        Vec3 direction = entity.m_20252_(1.0f);
        Vec3 origin = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        HitResult hitResult = configuration.settings().perform(entity, origin, direction, configuration.biEntityCondition());
        RaycastConfiguration.CommandInfo commandInfo = configuration.commandInfo();
        RaycastConfiguration.HitAction actions = configuration.action();
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            if (commandInfo.commandAtHit() != null) {
                Vec3 offsetDirection = direction;
                double offset = 0.0;
                Vec3 hitPos = hitResult.m_82450_();
                if (commandInfo.commandHitOffset() != null) {
                    offset = commandInfo.commandHitOffset();
                } else {
                    if (hitResult instanceof BlockHitResult) {
                        BlockHitResult bhr = (BlockHitResult)hitResult;
                        if (bhr.m_82434_() == Direction.DOWN) {
                            offset = entity.m_20206_();
                        } else if (bhr.m_82434_() == Direction.UP) {
                            offset = 0.0;
                        } else {
                            offset = entity.m_20205_() / 2.0f;
                            offsetDirection = new Vec3((double)(-bhr.m_82434_().m_122429_()), (double)(-bhr.m_82434_().m_122430_()), (double)(-bhr.m_82434_().m_122431_())).m_82548_();
                        }
                    }
                    offset += 0.05;
                }
                Vec3 at = hitPos.m_82546_(offsetDirection.m_82490_(offset));
                RaycastAction.executeCommandAtHit(entity, at, commandInfo.commandAtHit());
            }
            if (commandInfo.commandAlongRay() != null) {
                RaycastAction.executeStepCommands(entity, origin, hitResult.m_82450_(), commandInfo.commandAlongRay(), commandInfo.commandStep());
            }
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult bhr = (BlockHitResult)hitResult;
                ConfiguredBlockAction.execute(actions.blockAction(), entity.f_19853_, bhr.m_82425_(), bhr.m_82434_());
            }
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult ehr = (EntityHitResult)hitResult;
                ConfiguredBiEntityAction.execute(actions.biEntityAction(), entity, ehr.m_82443_());
            }
            ConfiguredEntityAction.execute(actions.hitAction(), entity);
        } else {
            if (commandInfo.commandAlongRay() != null && !commandInfo.commandAlongRayOnlyOnHit()) {
                RaycastAction.executeStepCommands(entity, origin, hitResult.m_82450_(), commandInfo.commandAlongRay(), commandInfo.commandStep());
            }
            ConfiguredEntityAction.execute(actions.missAction(), entity);
        }
    }

    private static void executeStepCommands(Entity entity, Vec3 origin, Vec3 target, String command, double step) {
        Vec3 direction = target.m_82546_(origin).m_82541_();
        double length = origin.m_82554_(target);
        for (double current = 0.0; current < length; current += step) {
            CommandConfiguration.executeAt(entity, origin.m_82549_(direction.m_82490_(current)), command);
        }
    }

    private static void executeCommandAtHit(Entity entity, Vec3 hitPosition, String command) {
        CommandConfiguration.executeAt(entity, hitPosition, command);
    }

    private static BlockHitResult performBlockRaycast(Entity source, Vec3 origin, Vec3 target, ClipContext.Block shapeType, ClipContext.Fluid fluidHandling) {
        ClipContext context = new ClipContext(origin, target, shapeType, fluidHandling, source);
        return source.f_19853_.m_45547_(context);
    }

    private static EntityHitResult performEntityRaycast(Entity source, Vec3 origin, Vec3 target, ConfiguredBiEntityCondition<?, ?> biEntityCondition) {
        Vec3 ray = target.m_82546_(origin);
        AABB box = source.m_142469_().m_82369_(ray).m_82377_(1.0, 1.0, 1.0);
        return ProjectileUtil.m_37287_((Entity)source, (Vec3)origin, (Vec3)target, (AABB)box, entityx -> !entityx.m_5833_() && ConfiguredBiEntityCondition.check(biEntityCondition, source, entityx), (double)ray.m_82556_());
    }
}

