/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.fabric.FabricPowerConfiguration;
import io.github.edwinmindcraft.apoli.fabric.FabricPowerFactory;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.Lazy;

public class PowerFactory<P extends Power> {
    private final ResourceLocation id;
    private final Lazy<io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory<?>> wrapped;
    private boolean hasConditions = false;

    public PowerFactory(ResourceLocation id, SerializableData data, Function<SerializableData.Instance, BiFunction<PowerType<P>, LivingEntity, P>> factoryConstructor) {
        this.id = id;
        this.wrapped = Lazy.of(() -> new FabricPowerFactory(FabricPowerConfiguration.codec(data, factoryConstructor), this.hasConditions));
    }

    public PowerFactory(ResourceLocation id, io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory<?> factory) {
        this.id = id;
        this.wrapped = Lazy.of(() -> factory);
    }

    public io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory<?> getWrapped() {
        return (io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory)((Object)this.wrapped.get());
    }

    public PowerFactory<P> allowCondition() {
        if (!this.hasConditions) {
            this.hasConditions = true;
        }
        return this;
    }

    public ResourceLocation getSerializerId() {
        return this.id;
    }

    public Instance read(JsonObject json) {
        return new Instance((ConfiguredPower)ConfiguredPower.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).map(Pair::getFirst).getOrThrow(false, s -> {}));
    }

    public Instance read(FriendlyByteBuf buffer) {
        return new Instance((ConfiguredPower)buffer.m_130057_(ConfiguredPower.CODEC));
    }

    public class Instance
    implements BiFunction<PowerType<P>, LivingEntity, P> {
        public final ConfiguredPower<?, ?> power;

        private Instance(ConfiguredPower<?, ?> power) {
            this.power = power;
        }

        public ConfiguredPower<?, ?> getPower() {
            return this.power;
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130085_(PowerFactory.this.id);
            buf.m_130059_(ConfiguredPower.CODEC, this.power);
        }

        @Override
        public P apply(PowerType<P> pPowerType, LivingEntity livingEntity) {
            Object obj = this.power.getConfiguration();
            if (obj instanceof FabricPowerConfiguration) {
                FabricPowerConfiguration config = (FabricPowerConfiguration)obj;
                return (Power)this.power.getPowerData((Entity)livingEntity, () -> config.power().apply(pPowerType, livingEntity));
            }
            return null;
        }
    }
}

