/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.fabric.FabricPowerConfiguration;
import java.util.Objects;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PowerType<T extends Power> {
    private final ResourceLocation identifier;
    private final ConfiguredPower<?, ?> configuredPower;
    private final PowerFactory.Instance factory;

    public PowerType(ResourceLocation id, PowerFactory.Instance factory) {
        this.identifier = id;
        this.factory = factory;
        this.configuredPower = factory.getPower();
    }

    public PowerType(ConfiguredPower<?, ?> cp) {
        this.identifier = cp.getRegistryName();
        this.configuredPower = cp;
        this.factory = null;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public PowerFactory.Instance getFactory() {
        return this.factory;
    }

    public ConfiguredPower<?, ?> getConfiguredPower() {
        return this.configuredPower;
    }

    public PowerType<T> setHidden() {
        return this;
    }

    public void setTranslationKeys(String name, String description) {
    }

    public T create(LivingEntity entity) {
        return (T)this.getFactory().apply(this, entity);
    }

    public boolean isHidden() {
        return this.configuredPower.getData().hidden();
    }

    public boolean isActive(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.identifier != null) {
                return IPowerContainer.get((Entity)living).resolve().map(x -> x.getPower(this.identifier)).map(x -> x.isActive((Entity)living)).orElse(false);
            }
        }
        return false;
    }

    public T get(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return (T)((Power)IPowerContainer.get((Entity)living).resolve().map(x -> x.getPower(this.identifier)).map(cp -> {
                Object patt2384$temp = cp.getConfiguration();
                if (patt2384$temp instanceof FabricPowerConfiguration) {
                    FabricPowerConfiguration config = (FabricPowerConfiguration)patt2384$temp;
                    return (Power)config.power().apply(this, living);
                }
                return null;
            }).orElse(null));
        }
        return null;
    }

    public String getOrCreateNameTranslationKey() {
        return this.configuredPower.getData().name();
    }

    public TranslatableComponent getName() {
        return this.configuredPower.getData().getName();
    }

    public String getOrCreateDescriptionTranslationKey() {
        return this.configuredPower.getData().description();
    }

    public TranslatableComponent getDescription() {
        return this.configuredPower.getData().getDescription();
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PowerType)) {
            return false;
        }
        PowerType pt = (PowerType)obj;
        return Objects.equals(this.identifier, pt.getIdentifier());
    }
}

