/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.ModifiableFoodEntity;
import io.github.edwinmindcraft.apoli.common.power.ModifyFoodPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyFoodConfiguration;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoodData.class})
public class HungerManagerMixin {
    @Shadow
    private int f_38696_;
    @Shadow
    private float f_38697_;
    @Unique
    private Player player;
    @Unique
    private boolean apoli$ShouldUpdateManually = false;

    @Redirect(method={"eat(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodProperties;getNutrition()I"))
    private int modifyHunger(FoodProperties foodComponent, Item item, ItemStack stack) {
        int nutrition = foodComponent.m_38744_();
        if (this.player != null) {
            int change = (int)ModifyFoodPower.apply(((ModifiableFoodEntity)this.player).getCurrentModifyFoodPowers(), this.player.f_19853_, stack, nutrition, ModifyFoodConfiguration::foodModifiers);
            if (change != nutrition) {
                this.apoli$ShouldUpdateManually = true;
            }
            return change;
        }
        return nutrition;
    }

    @Redirect(method={"eat(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodProperties;getSaturationModifier()F"))
    private float modifySaturation(FoodProperties foodComponent, Item item, ItemStack stack) {
        float saturationModifier = foodComponent.m_38745_();
        if (this.player != null) {
            float change = (float)ModifyFoodPower.apply(((ModifiableFoodEntity)this.player).getCurrentModifyFoodPowers(), this.player.f_19853_, stack, saturationModifier, ModifyFoodConfiguration::saturationModifiers);
            if (change != saturationModifier) {
                this.apoli$ShouldUpdateManually = true;
            }
            return change;
        }
        return saturationModifier;
    }

    @Inject(method={"eat(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;eat(IF)V", shift=At.Shift.AFTER)})
    private void executeAdditionalEatAction(Item item, ItemStack stack, CallbackInfo ci) {
        if (this.player != null) {
            Player player;
            ModifyFoodPower.execute(((ModifiableFoodEntity)this.player).getCurrentModifyFoodPowers(), (Entity)this.player, this.player.f_19853_, stack);
            if (this.apoli$ShouldUpdateManually && !this.player.f_19853_.m_5776_() && (player = this.player) instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.f_8906_.m_141995_((Packet)new ClientboundSetHealthPacket(this.player.m_21223_(), this.f_38696_, this.f_38697_));
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void cachePlayer(Player player, CallbackInfo ci) {
        this.player = player;
    }
}

