/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.MovingEntity;
import io.github.apace100.apoli.access.SubmergableEntity;
import io.github.apace100.apoli.access.WaterMovingEntity;
import io.github.apace100.calio.Calio;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.common.power.DummyPower;
import io.github.edwinmindcraft.apoli.common.power.InvisibilityPower;
import io.github.edwinmindcraft.apoli.common.power.PhasingPower;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements MovingEntity,
SubmergableEntity {
    @Shadow
    public Level f_19853_;
    @Shadow
    public float f_19788_;
    @Shadow
    @Nullable
    protected Tag<Fluid> f_19801_;
    @Shadow
    protected Object2DoubleMap<Tag<Fluid>> f_19799_;
    private boolean isMoving;
    private float distanceBefore;

    @Inject(method={"fireImmune"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeFullyFireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (IPowerContainer.hasPower((Entity)this, (DummyPower)ApoliPowers.FIRE_IMMUNITY.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Shadow
    public abstract double m_20120_(Tag<Fluid> var1);

    @Inject(method={"isInWater"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeEntitiesIgnoreWater(CallbackInfoReturnable<Boolean> cir) {
        if (IPowerContainer.hasPower((Entity)this, (DummyPower)ApoliPowers.IGNORE_WATER.get()) && this instanceof WaterMovingEntity && ((WaterMovingEntity)((Object)this)).isInMovementPhase()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isInWaterRainOrBubble()Z"))
    private boolean preventExtinguishingFromSwimming(Entity entity) {
        if (IPowerContainer.hasPower(entity, (DummyPower)ApoliPowers.SWIMMING.get()) && entity.m_6069_() && !(this.m_20120_((Tag<Fluid>)FluidTags.f_13131_) > 0.0)) {
            return false;
        }
        return entity.m_20071_();
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvisible"}, cancellable=true)
    private void phantomInvisibility(CallbackInfoReturnable<Boolean> info) {
        if (IPowerContainer.hasPower((Entity)this, (InvisibilityPower)ApoliPowers.INVISIBILITY.get())) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"moveTowardsClosestSpace"}, cancellable=true)
    protected void pushOutOfBlocks(double x, double y, double z, CallbackInfo info) {
        if (PhasingPower.shouldPhaseThrough((Entity)this, new BlockPos(x, y, z))) {
            info.cancel();
        }
    }

    @Inject(method={"move"}, at={@At(value="HEAD")})
    private void saveDistanceTraveled(MoverType type, Vec3 movement, CallbackInfo ci) {
        this.isMoving = false;
        this.distanceBefore = this.f_19788_;
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V")})
    private void checkIsMoving(MoverType type, Vec3 movement, CallbackInfo ci) {
        if (this.f_19788_ > this.distanceBefore) {
            this.isMoving = true;
        }
    }

    @Override
    public boolean isSubmergedInLoosely(Tag<Fluid> tag) {
        if (tag == null || this.f_19801_ == null) {
            return false;
        }
        if (tag == this.f_19801_) {
            return true;
        }
        return Calio.areTagsEqual(Registry.f_122899_, tag, this.f_19801_);
    }

    @Override
    public double getFluidHeightLoosely(Tag<Fluid> tag) {
        if (tag == null) {
            return 0.0;
        }
        if (this.f_19799_.containsKey(tag)) {
            return this.f_19799_.getDouble(tag);
        }
        for (Tag ft : this.f_19799_.keySet()) {
            if (!Calio.areTagsEqual(Registry.f_122899_, ft, tag)) continue;
            return this.f_19799_.getDouble((Object)ft);
        }
        return 0.0;
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }
}

