/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.edwinmindcraft.apoli.api.power.INightVisionPower;
import io.github.edwinmindcraft.apoli.common.power.LavaVisionPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyCameraSubmersionTypePower;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={FogRenderer.class})
public abstract class BackgroundRendererMixin {
    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z", ordinal=1), method={"setupColor"})
    private static boolean hasStatusEffectProxy(LivingEntity player, MobEffect effect) {
        if (player instanceof Player && effect == MobEffects.f_19611_ && !player.m_21023_(MobEffects.f_19611_)) {
            return INightVisionPower.getNightVisionStrength((Entity)player).isPresent();
        }
        return player.m_21023_(effect);
    }

    @ModifyVariable(method={"setupColor"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;getEntity()Lnet/minecraft/world/entity/Entity;", ordinal=0), ordinal=0)
    private static FogType modifyCameraSubmersionTypeRender(FogType original, Camera camera) {
        return ModifyCameraSubmersionTypePower.tryReplace(camera.m_90592_(), original).orElse(original);
    }

    @ModifyVariable(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;FZF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;getEntity()Lnet/minecraft/world/entity/Entity;", ordinal=0), ordinal=0)
    private static FogType modifyCameraSubmersionTypeFog(FogType original, Camera camera, FogRenderer.FogMode fogType, float viewDistance, boolean thickFog, float partialTicks) {
        return ModifyCameraSubmersionTypePower.tryReplace(camera.m_90592_(), original).orElse(original);
    }

    @ModifyConstant(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;FZF)V"}, constant={@Constant(floatValue=0.25f, ordinal=1)}, remap=false)
    private static float modifyLavaVisibilitySNoPotion(float original, Camera camera) {
        return LavaVisionPower.getS(camera.m_90592_()).orElse(Float.valueOf(original)).floatValue();
    }

    @ModifyConstant(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;FZF)V"}, constant={@Constant(floatValue=1.0f, ordinal=0)}, remap=false)
    private static float modifyLavaVisibilityVNoPotion(float original, Camera camera) {
        return LavaVisionPower.getV(camera.m_90592_()).orElse(Float.valueOf(original)).floatValue();
    }

    @ModifyConstant(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;FZF)V"}, constant={@Constant(floatValue=0.0f, ordinal=0)}, remap=false)
    private static float modifyLavaVisibilitySWithPotion(float original, Camera camera) {
        return LavaVisionPower.getS(camera.m_90592_()).orElse(Float.valueOf(original)).floatValue();
    }

    @ModifyConstant(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;FZF)V"}, constant={@Constant(floatValue=3.0f, ordinal=0)}, remap=false)
    private static float modifyLavaVisibilityVWithPotion(float original, Camera camera) {
        return LavaVisionPower.getV(camera.m_90592_()).orElse(Float.valueOf(original)).floatValue();
    }
}

