/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.command;

import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import net.minecraft.Util;
import net.minecraft.network.chat.TranslatableComponent;

public abstract class JsonObjectArgument<T>
implements ArgumentType<T> {
    public static final DynamicCommandExceptionType ERROR_INVALID_JSON = new DynamicCommandExceptionType(p_87121_ -> new TranslatableComponent("argument.component.invalid", new Object[]{p_87121_}));
    private static final Field JSON_READER_POS = (Field)Util.m_137537_(() -> {
        try {
            new JsonReader((Reader)new StringReader(""));
            Field field = JsonReader.class.getDeclaredField("pos");
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException nosuchfieldexception) {
            throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", nosuchfieldexception);
        }
    });
    private static final Field JSON_READER_LINESTART = (Field)Util.m_137537_(() -> {
        try {
            new JsonReader((Reader)new StringReader(""));
            Field field = JsonReader.class.getDeclaredField("lineStart");
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException nosuchfieldexception) {
            throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", nosuchfieldexception);
        }
    });

    protected abstract T convert(JsonReader var1) throws IOException;

    public T parse(com.mojang.brigadier.StringReader reader) throws CommandSyntaxException {
        try {
            try {
                JsonReader jsonreader = new JsonReader((Reader)new StringReader(reader.getRemaining()));
                jsonreader.setLenient(false);
                T obj = this.convert(jsonreader);
                reader.setCursor(reader.getCursor() + JsonObjectArgument.getPos(jsonreader));
                if (obj == null) {
                    throw ERROR_INVALID_JSON.createWithContext((ImmutableStringReader)reader, (Object)"empty");
                }
                return obj;
            }
            catch (IOException | StackOverflowError ioexception) {
                throw new JsonParseException(ioexception);
            }
        }
        catch (Exception exception) {
            String s = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            throw ERROR_INVALID_JSON.createWithContext((ImmutableStringReader)reader, (Object)s);
        }
    }

    private static int getPos(JsonReader pReader) {
        try {
            return JSON_READER_POS.getInt(pReader) - JSON_READER_LINESTART.getInt(pReader) + 1;
        }
        catch (IllegalAccessException illegalaccessexception) {
            throw new IllegalStateException("Couldn't read position of JsonReader", illegalaccessexception);
        }
    }
}

